<?xml version="1.0" encoding="ISO-8859-15"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:template match="Gene">
    <html>
      <body>
      	<STYLE>
			TD.std_r{border-top:1px solid black;}TD.std_r{border-right:1px solid black;}TD.std_r{border-left:1px solid black;}TD.std_r{border-bottom:1px solid black;}TD.std_r{background-color:#CDCDCD;}TD.std_r{font-size: 12pt;}TD.std_r{font-weight:bold;}TD.std_r{font-family:'arial';}TD.std_r{height:'0.4cm';}TD.std_r{text-align:left;}
			TD.std_a{border-top:1px solid black;}TD.std_a{border-right:1px solid black;}TD.std_a{border-left:1px solid black;}TD.std_a{border-bottom:1px solid black;}TD.std_a{background-color:#EDEDED;}TD.std_a{font-size: 10pt;}TD.std_a{font-weight:bold;}TD.std_a{font-family:'arial';}TD.std_a{height:'0.4cm';}TD.std_a{text-align:left;}
			TD.std_b{border-top:1px solid black;}TD.std_b{border-right:1px solid black;}TD.std_b{border-left:1px solid black;}TD.std_b{border-bottom:1px solid black;}TD.std_b{font-size: 10pt;}TD.std_b{font-family:'arial';}TD.std_b{height:'0.4cm';}TD.std_b{text-align:left;}
		</STYLE>
        <xsl:apply-templates select="Indi"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="Indi">
   	<TABLE cellspacing='0' cellpadding='4' border='1' bordercolor='black' width='700'>
		<TR>
			<TD class='std_r' colspan='4'><xsl:apply-templates select="SOSA" /></TD>
		</TR>
		<TR>
			<TD class='std_a' width='100'>Nom</TD>
			<TD class='std_b' colspan='3'><xsl:apply-templates select="Name" /></TD>
		</TR>
		<TR>
			<TD class='std_a'>Prnom</TD>
			<TD class='std_b' colspan='3'><xsl:apply-templates select="Nickname" /></TD>
		</TR>
		<TR>
			<TD class='std_a' width='100'>Naissance</TD>
			<xsl:apply-templates select="Naissance" />
		</TR>
		<TR>
			<TD class='std_a'>Mariage</TD>
			<xsl:apply-templates select="Mariage" />
		</TR>
		<TR>
			<TD class='std_a' width='100'>Dcs</TD>
			<xsl:apply-templates select="Deces" />
		</TR>
		<TR>
			<TD class='std_a' width='100'>Informations diverses</TD>
			<TD class='std_b' colspan='3'><BR></BR><BR></BR><BR></BR><BR></BR><BR></BR><BR></BR><BR></BR><BR></BR></TD>
		</TR>				
	</TABLE>
	<BR></BR>
   
  </xsl:template>

  <xsl:template match="SOSA">
    <font size='+2'><xsl:value-of select="." /></font>
  </xsl:template>

  <xsl:template match="Naissance">
	  <xsl:apply-templates select="Date"/> 
	  <xsl:apply-templates select="Lieu"/> 
  </xsl:template>

  <xsl:template match="Deces">
	  <xsl:apply-templates select="Date"/> 
	  <xsl:apply-templates select="Lieu"/> 
  </xsl:template>

  <xsl:template match="Mariage">
	  <xsl:apply-templates select="Date"/> 
	  <xsl:apply-templates select="Lieu"/> 
  </xsl:template>

  <xsl:template match="Date">
	<td class='std_b' width='150'>
	  <xsl:apply-templates select="Jour"/> 
	  <block><xsl:text xml:space="preserve">/</xsl:text></block>
	  <xsl:apply-templates select="Mois"/>
	  <block><xsl:text xml:space="preserve">/</xsl:text></block>
	  <xsl:apply-templates select="Annee"/>
  </td>
  </xsl:template>

  <xsl:template match="Lieu">
	<td class='std_a' width='80'>Lieu</td>
	<td class='std_b' width='150'><xsl:value-of select="." /></td>
  </xsl:template>

  <xsl:template match="Nom">
    <xsl:value-of select="." />
  </xsl:template>

  <xsl:template match="Prenom">
    <xsl:value-of select="." />
  </xsl:template>

</xsl:stylesheet>
